<?php
namespace App\Models;

use Core\Model;

/**
 * ApiCredential Model
 * Beheert API credentials voor VPS1 authenticatie
 */
class ApiCredential extends Model
{
    protected string $table = 'api_credentials';

    /**
     * Haal actieve API credentials op
     */
    public function getActiveCredentials(): ?array
    {
        return $this->queryOne(
            "SELECT * FROM {$this->table} WHERE is_active = 1 ORDER BY id DESC LIMIT 1"
        );
    }

    /**
     * Haal credentials op op basis van API key (voor verificatie)
     */
    public function findByApiKey(string $apiKey): ?array
    {
        return $this->where('api_key', $apiKey);
    }

    /**
     * Update last used timestamp
     */
    public function updateLastUsed(int $id): bool
    {
        return $this->db->execute(
            "UPDATE {$this->table} SET last_used_at = NOW() WHERE id = ?",
            [$id]
        );
    }

    /**
     * Genereer nieuwe API credentials
     */
    public function generateNewCredentials(int $id): bool
    {
        // Genereer veilige random strings
        $apiKey = 'vps2_' . bin2hex(random_bytes(16));
        $apiSecret = 'sk_' . bin2hex(random_bytes(32));
        $webhookSecret = 'wh_' . bin2hex(random_bytes(24));

        return $this->db->execute(
            "UPDATE {$this->table} 
             SET api_key = ?, 
                 api_secret = ?, 
                 webhook_secret = ?,
                 updated_at = NOW()
             WHERE id = ?",
            [$apiKey, $apiSecret, $webhookSecret, $id]
        );
    }

    /**
     * Maak nieuwe credentials aan met gegenereerde waarden
     */
    public function createWithGeneratedCredentials(string $name = 'VPS1 API Key'): ?int
    {
        // Genereer veilige random strings
        $apiKey = 'vps2_' . bin2hex(random_bytes(16));
        $apiSecret = 'sk_' . bin2hex(random_bytes(32));
        $webhookSecret = 'wh_' . bin2hex(random_bytes(24));

        $sql = "INSERT INTO {$this->table} 
                (name, api_key, api_secret, webhook_secret, is_active, created_at, updated_at)
                VALUES (?, ?, ?, ?, 1, NOW(), NOW())";

        if ($this->db->execute($sql, [$name, $apiKey, $apiSecret, $webhookSecret])) {
            return (int) $this->db->lastInsertId();
        }

        return null;
    }
}

