<?php
namespace App\Models;

use Core\Model;

/**
 * FurnitureProduct Model
 * Beheert furniture producten op VPS2
 */
class FurnitureProduct extends Model
{
    protected string $table = 'furniture_products';

    /**
     * Product ophalen op product_id
     */
    public function findByProductId(string $productId): ?array
    {
        return $this->where('product_id', $productId);
    }

    /**
     * Alle actieve producten
     */
    public function getActive(): array
    {
        // BOOLEAN kolom: is_active kan 0 of 1 zijn, maar MySQL accepteert ook true/1
        // Gebruik beide checks voor compatibility
        return $this->db->query(
            "SELECT * FROM {$this->table} WHERE is_active = 1 OR is_active = true ORDER BY name ASC"
        );
    }

    /**
     * Product aanmaken of updaten
     */
    public function createOrUpdate(array $data): ?string
    {
        // Check of product al bestaat
        $existing = $this->findByProductId($data['product_id']);
        
        if ($existing) {
            // Update
            $this->update($existing['id'], $data);
            return $existing['id'];
        } else {
            // Create
            return $this->create($data);
        }
    }
}

