<?php
namespace App\Models;

use Core\Model;

/**
 * FurnitureProductImage Model
 * Beheert furniture product afbeeldingen (meerdere foto's per product)
 */
class FurnitureProductImage extends Model
{
    protected string $table = 'furniture_product_images';

    /**
     * Alle afbeeldingen voor een product ophalen
     */
    public function getByProduct(int $productId): array
    {
        return $this->query(
            "SELECT * FROM {$this->table} WHERE product_id = ? ORDER BY is_primary DESC, sort_order ASC, id ASC",
            [$productId]
        );
    }

    /**
     * Hoofdfoto ophalen
     */
    public function getPrimary(int $productId): ?array
    {
        $result = $this->query(
            "SELECT * FROM {$this->table} WHERE product_id = ? AND is_primary = 1 LIMIT 1",
            [$productId]
        );
        return !empty($result) ? $result[0] : null;
    }

    /**
     * Afbeelding toevoegen
     */
    public function addImage(int $productId, string $imagePath, bool $isPrimary = false, int $sortOrder = 0): ?int
    {
        // Als dit de primaire is, maak andere primaire afbeeldingen secundair
        if ($isPrimary) {
            $this->db->getConnection()->exec(
                "UPDATE {$this->table} SET is_primary = 0 WHERE product_id = {$productId}"
            );
        }

        $data = [
            'product_id' => $productId,
            'image_path' => $imagePath,
            'is_primary' => $isPrimary ? 1 : 0,
            'sort_order' => $sortOrder
        ];

        return $this->create($data);
    }

    /**
     * Volgorde updaten
     */
    public function updateSortOrder(int $imageId, int $sortOrder): bool
    {
        return $this->update($imageId, ['sort_order' => $sortOrder]);
    }

    /**
     * Als primaire afbeelding instellen
     */
    public function setPrimary(int $imageId, int $productId): bool
    {
        // Maak alle andere primaire afbeeldingen secundair
        $this->db->getConnection()->exec(
            "UPDATE {$this->table} SET is_primary = 0 WHERE product_id = {$productId}"
        );

        // Stel deze in als primair
        return $this->update($imageId, ['is_primary' => 1]);
    }

    /**
     * Afbeelding verwijderen
     */
    public function removeImage(int $imageId): bool
    {
        return $this->delete($imageId);
    }
}
