<?php
// View wordt geladen via public.php layout
?>

<div class="checkout-container">
    <div class="checkout-header">
        <h1><i class="fas fa-credit-card"></i> Afrekenen</h1>
        <p>Order: <?= htmlspecialchars($order['external_order_id']) ?></p>
    </div>

    <div class="checkout-content">
        <div class="order-summary">
            <h2>Orderoverzicht</h2>
            <div class="order-item">
                <div class="item-info">
                    <h3><?= htmlspecialchars($order['product_name']) ?></h3>
                    <p>Aantal: <?= $order['quantity'] ?></p>
                </div>
                <div class="item-price">
                    €<?= number_format($order['price'], 2, ',', '.') ?>
                </div>
            </div>
            <div class="order-total">
                <strong>Totaal: €<?= number_format($order['price'], 2, ',', '.') ?></strong>
            </div>
        </div>

        <div class="payment-section">
            <h2>Betaalgegevens</h2>
            <p class="payment-info">
                <i class="fas fa-info-circle"></i> 
                Dit is een test omgeving. Klik op de knop hieronder om de betaling te simuleren.
            </p>
            
            <form method="POST" action="<?= url('/checkout/' . $order['furniture_order_id'] . '/pay') ?>">
                <button type="submit" class="btn-pay">
                    <i class="fas fa-check"></i> Betaal nu (Test)
                </button>
            </form>
        </div>
    </div>
</div>

<style>
.checkout-container {
    max-width: 800px;
    margin: 4rem auto;
    padding: 2rem;
}

.checkout-header {
    text-align: center;
    margin-bottom: 3rem;
}

.checkout-header h1 {
    font-size: 2.5rem;
    color: #0f172a;
    margin-bottom: 0.5rem;
}

.checkout-header p {
    color: #64748b;
    font-size: 1.125rem;
}

.checkout-content {
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    padding: 2rem;
}

.order-summary {
    margin-bottom: 2rem;
    padding-bottom: 2rem;
    border-bottom: 2px solid #e2e8f0;
}

.order-summary h2 {
    font-size: 1.5rem;
    color: #0f172a;
    margin-bottom: 1.5rem;
}

.order-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    background: #f8fafc;
    border-radius: 8px;
    margin-bottom: 1rem;
}

.item-info h3 {
    margin: 0 0 0.5rem 0;
    color: #0f172a;
}

.item-info p {
    margin: 0;
    color: #64748b;
    font-size: 0.875rem;
}

.item-price {
    font-size: 1.25rem;
    font-weight: 600;
    color: #dc2626;
}

.order-total {
    text-align: right;
    padding-top: 1rem;
    font-size: 1.5rem;
    color: #0f172a;
}

.payment-section h2 {
    font-size: 1.5rem;
    color: #0f172a;
    margin-bottom: 1rem;
}

.payment-info {
    background: #dbeafe;
    color: #1e40af;
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 2rem;
    border-left: 4px solid #3b82f6;
}

.btn-pay {
    width: 100%;
    background: #16a34a;
    color: white;
    border: none;
    padding: 1.25rem 2rem;
    border-radius: 8px;
    font-size: 1.25rem;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.2s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.75rem;
}

.btn-pay:hover {
    background: #15803d;
}

.btn-pay i {
    font-size: 1.5rem;
}
</style>
