<div style="margin-bottom: 2rem;">
    <a href="<?= url('/dashboard/orders') ?>" style="color: #64748b; text-decoration: none;">
        <i class="fas fa-arrow-left"></i> Terug naar Orders
    </a>
</div>

<div class="card">
    <div class="card-header">
        <h3>Order Details: <?= e($order['furniture_order_id']) ?></h3>
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 2rem;">
            <div>
                <h4 style="margin-bottom: 1rem; color: #0f172a;">Order Informatie</h4>
                <table class="table" style="background: transparent;">
                    <tr>
                        <td><strong>Furniture Order ID:</strong></td>
                        <td><?= e($order['furniture_order_id']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>External Order ID:</strong></td>
                        <td><?= e($order['external_order_id']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Product ID:</strong></td>
                        <td><?= e($order['product_id']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Product Naam:</strong></td>
                        <td><?= e($order['product_name']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Quantity:</strong></td>
                        <td><?= e($order['quantity']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Prijs:</strong></td>
                        <td><?= format_price($order['price']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Currency:</strong></td>
                        <td><?= e($order['currency']) ?></td>
                    </tr>
                </table>
            </div>
            
            <div>
                <h4 style="margin-bottom: 1rem; color: #0f172a;">Payment Status</h4>
                <table class="table" style="background: transparent;">
                    <tr>
                        <td><strong>Status:</strong></td>
                        <td>
                            <span class="badge badge-<?= $order['payment_status'] === 'paid' ? 'success' : ($order['payment_status'] === 'failed' ? 'error' : 'warning') ?>">
                                <?= e($order['payment_status']) ?>
                            </span>
                        </td>
                    </tr>
                    <?php if ($order['transaction_id']): ?>
                    <tr>
                        <td><strong>Transaction ID:</strong></td>
                        <td><?= e($order['transaction_id']) ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($order['paid_at']): ?>
                    <tr>
                        <td><strong>Betaald op:</strong></td>
                        <td><?= format_date($order['paid_at']) ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($order['failed_at']): ?>
                    <tr>
                        <td><strong>Gefaald op:</strong></td>
                        <td><?= format_date($order['failed_at']) ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($order['failure_reason']): ?>
                    <tr>
                        <td><strong>Fout reden:</strong></td>
                        <td><?= e($order['failure_reason']) ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td><strong>Webhook Verzonden:</strong></td>
                        <td>
                            <?php if ($order['webhook_sent']): ?>
                                <span class="badge badge-success"><i class="fas fa-check"></i> Ja</span>
                                <?php if ($order['webhook_sent_at']): ?>
                                    <br><small><?= format_date($order['webhook_sent_at']) ?></small>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge badge-warning"><i class="fas fa-clock"></i> Nee</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <?php if ($order['payment_url']): ?>
        <div style="margin-top: 2rem; padding: 1rem; background: #f8fafc; border-radius: 6px;">
            <strong>Payment URL:</strong><br>
            <a href="<?= e($order['payment_url']) ?>" target="_blank" style="color: #0284c7; word-break: break-all;">
                <?= e($order['payment_url']) ?>
            </a>
        </div>
        <?php endif; ?>

        <?php if (!$order['webhook_sent'] && in_array($order['payment_status'], ['paid', 'failed', 'cancelled'])): ?>
        <div style="margin-top: 2rem;">
            <form method="POST" action="<?= url('/api/v1/orders/' . $order['furniture_order_id'] . '/webhook') ?>">
                <?= csrf_field() ?>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i> Stuur Webhook naar VPS1
                </button>
            </form>
        </div>
        <?php endif; ?>
    </div>
</div>

