<!-- Stats Cards -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon orange">
            <i class="fas fa-clock"></i>
        </div>
        <div class="stat-details">
            <div class="stat-label">Openstaande Orders</div>
            <div class="stat-value"><?= isset($stats['pending']) ? $stats['pending'] : 0 ?></div>
            <div class="stat-change" style="color: var(--text-secondary); font-size: 0.875rem;">
                Wachten op betaling
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon green">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-details">
            <div class="stat-label">Verzonden Orders</div>
            <div class="stat-value"><?= isset($stats['paid']) ? $stats['paid'] : 0 ?></div>
            <div class="stat-change positive">
                <i class="fas fa-check"></i>
                Succesvol afgerond
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon red">
            <i class="fas fa-times-circle"></i>
        </div>
        <div class="stat-details">
            <div class="stat-label">Mislukte Orders</div>
            <div class="stat-value"><?= isset($stats['failed']) ? $stats['failed'] : 0 ?></div>
            <div class="stat-change negative">
                <i class="fas fa-exclamation-triangle"></i>
                Betaling mislukt
            </div>
        </div>
    </div>
    
    <?php if (isset($stats['cancelled']) && $stats['cancelled'] > 0): ?>
    <div class="stat-card">
        <div class="stat-icon" style="background: rgba(100, 116, 139, 0.08); color: #64748b;">
            <i class="fas fa-ban"></i>
        </div>
        <div class="stat-details">
            <div class="stat-label">Geannuleerd</div>
            <div class="stat-value"><?= $stats['cancelled'] ?></div>
            <div class="stat-change" style="color: var(--text-secondary); font-size: 0.875rem;">
                Door klant geannuleerd
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Orders Table Card -->
<div class="card">
    <div class="orders-tabs">
        <button type="button" class="order-tab active" data-status="">Alle</button>
        <button type="button" class="order-tab" data-status="pending">Openstaand</button>
        <button type="button" class="order-tab" data-status="paid">Verzonden</button>
        <button type="button" class="order-tab" data-status="cancelled">Geannuleerd</button>
    </div>
    <div class="card-header">
        <div>
            <h3>Alle Orders</h3>
            <?php if (isset($pagination)): ?>
                <p style="font-size: 0.875rem; color: var(--text-secondary); margin-top: 0.25rem;">
                    Toon <?= ($pagination['current_page'] - 1) * $pagination['per_page'] + 1 ?> - 
                    <?= min($pagination['current_page'] * $pagination['per_page'], $pagination['total_orders']) ?> 
                    van <?= $pagination['total_orders'] ?> orders
                </p>
            <?php endif; ?>
        </div>
        <div style="display: flex; gap: 0.75rem;">
            <button class="btn btn-secondary btn-sm" onclick="window.location.reload()">
                <i class="fas fa-sync-alt"></i>
                Ververs
            </button>
        </div>
    </div>
    
    <?php if (!empty($orders)): ?>
        <div class="table-responsive">
            <table class="table" id="ordersTable">
                <thead>
                    <tr>
                        <th>Order #</th>
                        <th>Internal ID</th>
                        <th>Product</th>
                        <th class="text-right">Prijs</th>
                        <th>Status</th>
                        <th>Webhook</th>
                        <th>Datum</th>
                        <th class="text-center">Acties</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($orders as $order): ?>
                        <tr data-payment-status="<?= e($order['payment_status']) ?>">
                            <td>
                                <strong><?= e($order['external_order_id']) ?></strong>
                            </td>
                            <td>
                                <span style="color: var(--text-secondary); font-size: 0.875rem; font-family: var(--font-mono);">
                                    <?= e($order['furniture_order_id']) ?>
                                </span>
                            </td>
                            <td>
                                <span style="font-weight: 500;">
                                    <?= e($order['product_name']) ?>
                                </span>
                            </td>
                            <td class="text-right price-cell">
                                <span style="font-weight: 600; font-family: var(--font-mono); white-space: nowrap;">
                                    <?= format_price($order['price']) ?>
                                </span>
                            </td>
                            <td>
                                <?php
                                $badgeClass = 'badge-warning';
                                $statusIcon = 'fa-clock';
                                $statusText = 'Openstaand';
                                
                                if ($order['payment_status'] === 'paid') {
                                    $badgeClass = 'badge-success';
                                    $statusIcon = 'fa-check-circle';
                                    $statusText = 'Verzonden';
                                } elseif ($order['payment_status'] === 'failed') {
                                    $badgeClass = 'badge-danger';
                                    $statusIcon = 'fa-times-circle';
                                    $statusText = 'Mislukt';
                                } elseif ($order['payment_status'] === 'cancelled') {
                                    $badgeClass = 'badge-secondary';
                                    $statusIcon = 'fa-ban';
                                    $statusText = 'Geannuleerd';
                                }
                                ?>
                                <span class="badge <?= $badgeClass ?>">
                                    <i class="fas <?= $statusIcon ?>"></i>
                                    <?= $statusText ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($order['webhook_sent']): ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-check"></i>
                                        Verzonden
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-warning">
                                        <i class="fas fa-clock"></i>
                                        Wachten
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span style="color: var(--text-secondary); font-size: 0.875rem;">
                                    <?= format_date($order['created_at']) ?>
                                </span>
                            </td>
                            <td class="text-center">
                                <?php if (!$order['webhook_sent'] && in_array($order['payment_status'], ['paid', 'failed', 'cancelled'])): ?>
                                    <form method="POST" action="<?= url('/api/v1/orders/' . $order['furniture_order_id'] . '/webhook') ?>" style="display: inline;">
                                        <?= csrf_field() ?>
                                        <button type="submit" class="btn btn-sm btn-primary" 
                                                onclick="return confirm('Webhook handmatig versturen?')" 
                                                title="Stuur Webhook">
                                            <i class="fas fa-paper-plane"></i>
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <span style="color: var(--text-tertiary);">—</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if (isset($pagination) && $pagination['total_pages'] > 1): ?>
            <div style="padding: 1.5rem; border-top: 1px solid var(--border-color); display: flex; align-items: center; justify-content: space-between;">
                <div>
                    <?php if ($pagination['has_prev']): ?>
                        <a href="<?= url('/dashboard/orders?page=' . ($pagination['current_page'] - 1)) ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-chevron-left"></i>
                            Vorige
                        </a>
                    <?php else: ?>
                        <button class="btn btn-secondary btn-sm" disabled>
                            <i class="fas fa-chevron-left"></i>
                            Vorige
                        </button>
                    <?php endif; ?>
                </div>
                
                <div style="display: flex; gap: 0.5rem; align-items: center;">
                    <?php
                    $startPage = max(1, $pagination['current_page'] - 2);
                    $endPage = min($pagination['total_pages'], $pagination['current_page'] + 2);
                    
                    if ($startPage > 1): ?>
                        <a href="<?= url('/dashboard/orders?page=1') ?>" class="btn btn-secondary btn-sm">1</a>
                        <?php if ($startPage > 2): ?>
                            <span style="color: var(--text-tertiary);">...</span>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                    <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                        <?php if ($i === $pagination['current_page']): ?>
                            <button class="btn btn-primary btn-sm"><?= $i ?></button>
                        <?php else: ?>
                            <a href="<?= url('/dashboard/orders?page=' . $i) ?>" class="btn btn-secondary btn-sm"><?= $i ?></a>
                        <?php endif; ?>
                    <?php endfor; ?>
                    
                    <?php if ($endPage < $pagination['total_pages']): ?>
                        <?php if ($endPage < $pagination['total_pages'] - 1): ?>
                            <span style="color: var(--text-tertiary);">...</span>
                        <?php endif; ?>
                        <a href="<?= url('/dashboard/orders?page=' . $pagination['total_pages']) ?>" class="btn btn-secondary btn-sm"><?= $pagination['total_pages'] ?></a>
                    <?php endif; ?>
                </div>
                
                <div>
                    <?php if ($pagination['has_next']): ?>
                        <a href="<?= url('/dashboard/orders?page=' . ($pagination['current_page'] + 1)) ?>" class="btn btn-secondary btn-sm">
                            Volgende
                            <i class="fas fa-chevron-right"></i>
                        </a>
                    <?php else: ?>
                        <button class="btn btn-secondary btn-sm" disabled>
                            Volgende
                            <i class="fas fa-chevron-right"></i>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    <?php else: ?>
        <div class="empty-state">
            <div class="empty-state-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <h3>Nog geen orders</h3>
            <p>Orders van VPS1 verschijnen hier automatisch zodra klanten een aankoop doen.</p>
        </div>
    <?php endif; ?>
</div>

<style>
.orders-tabs {
    display: flex;
    gap: 0.5rem;
    padding: 1rem 1.5rem;
    border-bottom: 1px solid var(--border-color, #e2e8f0);
    background: var(--gray-50, #f8fafc);
}

.order-tab {
    padding: 0.75rem 1.5rem;
    font-size: 0.9375rem;
    font-weight: 500;
    color: var(--text-secondary, #64748b);
    background: white;
    border: 1px solid var(--border-color, #e2e8f0);
    border-radius: 6px 6px 0 0;
    cursor: pointer;
    transition: all 0.2s ease;
    position: relative;
    margin-bottom: -1px;
    white-space: nowrap;
}

.order-tab:hover {
    color: var(--text-primary, #0f172a);
    background: white;
    border-color: var(--border-color, #e2e8f0);
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}

.order-tab.active {
    color: var(--primary, #0f172a);
    font-weight: 600;
    background: white;
    border-bottom-color: white;
    border-color: var(--border-color, #e2e8f0);
    border-bottom-color: transparent;
    z-index: 1;
    box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.05);
}

.order-tab:focus {
    outline: none;
    box-shadow: 0 0 0 3px rgba(15, 23, 42, 0.1);
}

.order-tab.active:focus {
    box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.05), 0 0 0 3px rgba(15, 23, 42, 0.1);
}

/* Badge Styling - Precies zoals Dashboard 1 */
.table .badge {
    padding: 0.25rem 0.625rem;
    font-size: 0.75rem;
    font-weight: 600;
    border-radius: 4px;
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    text-transform: capitalize;
}

/* Openstaand (pending) - badge-warning in Dashboard 2 */
.table .badge.badge-warning {
    background: #fef3c7;
    color: #92400e;
}

/* Verzonden (paid) - badge-success in Dashboard 2 */
.table .badge.badge-success {
    background: #d1fae5;
    color: #065f46;
}

/* Geannuleerd (cancelled) - badge-secondary in Dashboard 2 */
.table .badge.badge-secondary {
    background: #fee2e2;
    color: #991b1b;
}

/* Mislukt (failed) - badge-danger in Dashboard 2 */
.table .badge.badge-danger {
    background: #fee2e2;
    color: #991b1b;
}

@media (max-width: 768px) {
    .orders-tabs {
        padding: 0.75rem 1rem;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        gap: 0.375rem;
    }
    
    .order-tab {
        padding: 0.625rem 1.25rem;
        font-size: 0.875rem;
        flex-shrink: 0;
    }
}
</style>

<script>
(function() {
    'use strict';
    
    document.addEventListener('DOMContentLoaded', function() {
        const orderTabs = document.querySelectorAll('.order-tab');
        const table = document.getElementById('ordersTable');
        
        if (!table || orderTabs.length === 0) return;
        
        // Helper function to filter orders by payment status
        function filterOrdersByStatus(selectedStatus) {
            const tbody = table.querySelector('tbody');
            if (!tbody) return;
            
            const rows = tbody.getElementsByTagName('tr');

            for (let row of rows) {
                const status = row.getAttribute('data-payment-status');
                
                if (selectedStatus === '' || status === selectedStatus) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            }
        }

        // Helper function to update active tab
        function updateActiveTab(status) {
            orderTabs.forEach(function(tab) {
                const tabStatus = (tab.getAttribute('data-status') || '').toLowerCase();
                if (tabStatus === status) {
                    tab.classList.add('active');
                } else {
                    tab.classList.remove('active');
                }
            });
        }

        // Order tabs event listeners
        orderTabs.forEach(function(tab) {
            tab.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const selectedStatus = (this.getAttribute('data-status') || '').toLowerCase();
                
                // Update active tab
                updateActiveTab(selectedStatus);
                
                // Filter orders
                filterOrdersByStatus(selectedStatus);
            });
        });
    });
})();
</script>
