<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <h2 style="margin: 0;">Instellingen</h2>
    <div id="connection-status" style="display: flex; align-items: center; gap: 0.5rem; position: relative;">
        <div id="status-indicator" style="width: 12px; height: 12px; border-radius: 50%; background: #94a3b8; transition: background-color 0.3s, opacity 1s; box-shadow: 0 0 0 0 rgba(16, 185, 129, 0.7);"></div>
        <span id="status-text" style="font-size: 0.875rem; color: #64748b;">Controleren...</span>
    </div>
</div>

<!-- API Credentials -->
<div class="card" style="margin-bottom: 2rem;">
    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
        <h3>API Credentials (voor VPS1)</h3>
        <div style="font-size: 0.875rem; color: #64748b;">
            <i class="fas fa-info-circle"></i> 
            Kopieer deze waarden naar VPS1 API Settings
        </div>
    </div>
    <div class="card-body">
        <?php if ($credentials): ?>
            <div style="background: #f8fafc; padding: 1.5rem; border-radius: 8px; margin-bottom: 1.5rem;">
                <h4 style="margin-bottom: 1rem; color: #0f172a;">VPS1 API Settings Configuratie</h4>
                <p style="color: #64748b; margin-bottom: 1.5rem; font-size: 0.875rem;">
                    Gebruik deze waarden in VPS1 Dashboard → API Settings → Nieuwe API Connectie
                </p>
                
                <div style="display: grid; gap: 1rem;">
                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 0.5rem; color: #334155;">
                            <i class="fas fa-tag"></i> API Naam
                        </label>
                        <div style="display: flex; gap: 0.5rem; align-items: center;">
                            <code style="flex: 1; padding: 0.75rem; background: white; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.875rem;">
                                <?= e($credentials['name']) ?>
                            </code>
                            <button onclick="copyToClipboard('<?= e($credentials['name']) ?>', this)" 
                                    class="btn btn-sm" 
                                    style="background: #0f172a; color: white; padding: 0.5rem 1rem; border: none; border-radius: 6px; cursor: pointer;">
                                <i class="fas fa-copy"></i> Kopieer
                            </button>
                        </div>
                    </div>

                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 0.5rem; color: #334155;">
                            <i class="fas fa-link"></i> Base URL
                        </label>
                        <div style="display: flex; gap: 0.5rem; align-items: center;">
                            <code style="flex: 1; padding: 0.75rem; background: white; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.875rem; word-break: break-all;">
                                <?= e(config('app.url')) ?>
                            </code>
                            <button onclick="copyToClipboard('<?= e(config('app.url')) ?>', this)" 
                                    class="btn btn-sm" 
                                    style="background: #0f172a; color: white; padding: 0.5rem 1rem; border: none; border-radius: 6px; cursor: pointer;">
                                <i class="fas fa-copy"></i> Kopieer
                            </button>
                        </div>
                        <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                            <i class="fas fa-info-circle"></i> 
                            VPS1 voegt automatisch <code>/api/v1</code> toe aan de base URL
                        </small>
                    </div>

                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 0.5rem; color: #334155;">
                            <i class="fas fa-key"></i> API Key
                        </label>
                        <div style="display: flex; gap: 0.5rem; align-items: center;">
                            <code style="flex: 1; padding: 0.75rem; background: white; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.875rem; word-break: break-all; font-family: 'Courier New', monospace; letter-spacing: 0.5px;">
                                <?= e($credentials['api_key']) ?>
                            </code>
                            <button onclick="copyToClipboard('<?= e($credentials['api_key']) ?>', this)" 
                                    class="btn btn-sm" 
                                    style="background: #0f172a; color: white; padding: 0.5rem 1rem; border: none; border-radius: 6px; cursor: pointer;">
                                <i class="fas fa-copy"></i> Kopieer
                            </button>
                        </div>
                    </div>

                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 0.5rem; color: #334155;">
                            <i class="fas fa-lock"></i> API Secret
                        </label>
                        <div style="display: flex; gap: 0.5rem; align-items: center;">
                            <code style="flex: 1; padding: 0.75rem; background: white; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.875rem; word-break: break-all; font-family: 'Courier New', monospace; letter-spacing: 0.5px;">
                                <?= e($credentials['api_secret']) ?>
                            </code>
                            <button onclick="copyToClipboard('<?= e($credentials['api_secret']) ?>', this)" 
                                    class="btn btn-sm" 
                                    style="background: #0f172a; color: white; padding: 0.5rem 1rem; border: none; border-radius: 6px; cursor: pointer;">
                                <i class="fas fa-copy"></i> Kopieer
                            </button>
                        </div>
                    </div>

                    <?php if ($credentials['webhook_secret']): ?>
                    <div>
                        <label style="display: block; font-weight: 600; margin-bottom: 0.5rem; color: #334155;">
                            <i class="fas fa-shield-alt"></i> Webhook Secret (Optioneel)
                        </label>
                        <div style="display: flex; gap: 0.5rem; align-items: center;">
                            <code style="flex: 1; padding: 0.75rem; background: white; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 0.875rem; word-break: break-all; font-family: 'Courier New', monospace; letter-spacing: 0.5px;">
                                <?= e($credentials['webhook_secret']) ?>
                            </code>
                            <button onclick="copyToClipboard('<?= e($credentials['webhook_secret']) ?>', this)" 
                                    class="btn btn-sm" 
                                    style="background: #0f172a; color: white; padding: 0.5rem 1rem; border: none; border-radius: 6px; cursor: pointer;">
                                <i class="fas fa-copy"></i> Kopieer
                            </button>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <div style="display: flex; gap: 1rem; margin-top: 1.5rem;">
                <form method="POST" action="<?= url('/dashboard/settings/generate-credentials') ?>" style="flex: 1;">
                    <?= csrf_field() ?>
                    <button type="submit" 
                            class="btn btn-primary" 
                            style="width: 100%; padding: 0.75rem; background: #0f172a; color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 600;"
                            onclick="return confirm('Weet je zeker dat je nieuwe API credentials wilt genereren? De oude werken dan niet meer en je moet ze opnieuw instellen in VPS1!')">
                        <i class="fas fa-key"></i> Genereer Nieuwe API Credentials
                    </button>
                </form>
            </div>

            <div style="background: #fef3c7; border: 1px solid #fbbf24; padding: 1rem; border-radius: 6px; margin-top: 1rem;">
                <strong style="color: #92400e;"><i class="fas fa-exclamation-triangle"></i> Belangrijk:</strong>
                <ul style="margin: 0.5rem 0 0 1.5rem; color: #78350f; font-size: 0.875rem;">
                    <li>Kopieer deze waarden naar VPS1: <code>http://localhost/dashboard/api-settings/create</code></li>
                    <li>Base URL: <code><?= e(config('app.url')) ?></code> (zonder /api/v1)</li>
                    <li>API Key en Secret zijn nodig voor authenticatie</li>
                    <li>Webhook Secret is optioneel maar aanbevolen</li>
                    <li><strong>Let op:</strong> Als je nieuwe credentials genereert, moet je ze opnieuw instellen in VPS1!</li>
                </ul>
            </div>

            <table class="table" style="margin-top: 1.5rem;">
                <tr>
                    <td><strong>Status:</strong></td>
                    <td>
                        <?php if ($credentials['is_active']): ?>
                            <span class="badge badge-success">Actief</span>
                        <?php else: ?>
                            <span class="badge badge-error">Inactief</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php if ($credentials['last_used_at']): ?>
                <tr>
                    <td><strong>Laatst gebruikt:</strong></td>
                    <td><?= format_date($credentials['last_used_at']) ?></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td><strong>Created:</strong></td>
                    <td><?= format_date($credentials['created_at']) ?></td>
                </tr>
            </table>
        <?php else: ?>
            <div style="text-align: center; padding: 2rem;">
                <i class="fas fa-exclamation-circle" style="font-size: 3rem; color: #fbbf24; margin-bottom: 1rem;"></i>
                <h4 style="color: #0f172a; margin-bottom: 0.5rem;">Geen API credentials geconfigureerd</h4>
                <p style="color: #64748b; margin-bottom: 1.5rem;">
                    Voeg API credentials toe in de database (furniture_shop.api_credentials tabel)
                </p>
                <code style="background: #f8fafc; padding: 0.5rem 1rem; border-radius: 6px; font-size: 0.875rem;">
                    INSERT INTO api_credentials (name, api_key, api_secret, webhook_secret, is_active) 
                    VALUES ('VPS1 API Key', 'YOUR_KEY', 'YOUR_SECRET', 'YOUR_WEBHOOK_SECRET', 1);
                </code>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function copyToClipboard(text, button) {
    navigator.clipboard.writeText(text).then(function() {
        const original = button.innerHTML;
        button.innerHTML = '<i class="fas fa-check"></i> Gekopieerd!';
        button.style.background = '#059669';
        setTimeout(function() {
            button.innerHTML = original;
            button.style.background = '#0f172a';
        }, 2000);
    }).catch(function(err) {
        alert('Kopieer mislukt: ' + err);
    });
}

// Connection status checker
(function() {
    const indicator = document.getElementById('status-indicator');
    const statusText = document.getElementById('status-text');
    let isConnected = false;
    let animationInterval = null;

    function updateStatus(connected, message) {
        isConnected = connected;
        
        if (connected) {
            indicator.style.background = '#10b981'; // Groen
            indicator.style.boxShadow = '0 0 0 0 rgba(16, 185, 129, 0.7)';
            statusText.textContent = 'Verbonden met VPS1';
            statusText.style.color = '#059669';
            
            // Start knipper animatie (pulse effect)
            if (!animationInterval) {
                let opacity = 1;
                let scale = 1;
                animationInterval = setInterval(function() {
                    opacity = opacity === 1 ? 0.5 : 1;
                    scale = scale === 1 ? 1.1 : 1;
                    indicator.style.opacity = opacity;
                    indicator.style.transform = 'scale(' + scale + ')';
                    indicator.style.transition = 'opacity 1s ease-in-out, transform 1s ease-in-out';
                }, 1000); // Knipper elke seconde
            }
        } else {
            indicator.style.background = '#ef4444'; // Rood
            indicator.style.boxShadow = 'none';
            statusText.textContent = message || 'Geen verbinding';
            statusText.style.color = '#dc2626';
            indicator.style.opacity = 1;
            indicator.style.transform = 'scale(1)';
            
            // Stop knipper animatie
            if (animationInterval) {
                clearInterval(animationInterval);
                animationInterval = null;
            }
        }
    }

    function checkConnection() {
        fetch('<?= url('/dashboard/settings/check-connection') ?>')
            .then(response => response.json())
            .then(data => {
                // Gebruik alleen de message van de server (Verbonden of Niet verbonden)
                updateStatus(data.connected, data.message);
            })
            .catch(error => {
                updateStatus(false, 'Niet verbonden');
                console.error('Connection check error:', error);
            });
    }

    // Check direct en dan elke 10 seconden
    checkConnection();
    setInterval(checkConnection, 10000);
})();
</script>


