<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Dashboard' ?> - Oraviare</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Preload page-specific CSS to prevent layout shifts -->
    <?php
    $currentPath = $_SERVER['REQUEST_URI'] ?? '';
    if (strpos($currentPath, '/dashboard/categories') !== false) {
        echo '<link rel="preload" href="' . asset('css/categories.css') . '" as="style">';
    } elseif (strpos($currentPath, '/dashboard/products') !== false) {
        echo '<link rel="preload" href="' . asset('css/products.css') . '" as="style">';
    } elseif (strpos($currentPath, '/dashboard/orders') !== false) {
        echo '<link rel="preload" href="' . asset('css/orders.css') . '" as="style">';
    }
    ?>
    
    <link rel="stylesheet" href="<?= asset('css/style.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Critical CSS inline for categories page to prevent FOUC -->
    <?php if (strpos($currentPath, '/dashboard/categories') !== false): ?>
    <style>
        /* Critical Categories Table CSS - Prevents layout shift during page load */
        .categories-section {
            background: white !important;
            border: 1px solid #e2e8f0 !important;
            border-radius: 8px !important;
            overflow: hidden !important;
            /* Prevent layout shift */
            contain: layout style !important;
        }
        
        .categories-header {
            padding: 1rem 1.5rem !important;
            border-bottom: 1px solid #e2e8f0 !important;
            background: #f8fafc !important;
        }
        
        .categories-header h3 {
            font-size: 1rem !important;
            font-weight: 600 !important;
            color: #0f172a !important;
            margin: 0 !important;
        }
        
        .table-responsive {
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch !important;
        }
        
        .categories-table {
            width: 100% !important;
            border-collapse: separate !important;
            border-spacing: 0 !important;
            /* Fixed table layout prevents column collapse */
            table-layout: fixed !important;
        }
        
        .categories-table thead th {
            padding: 0.75rem 1rem !important;
            text-align: left !important;
            font-size: 0.75rem !important;
            font-weight: 700 !important;
            text-transform: uppercase !important;
            letter-spacing: 0.05em !important;
            color: #64748b !important;
            border-bottom: 2px solid #e2e8f0 !important;
            background: transparent !important;
            /* Fixed column widths to prevent collapse */
            white-space: nowrap !important;
        }
        
        /* Fixed column widths - prevents "ingeklapte" columns */
        .categories-table thead th:nth-child(1) { width: 60px !important; } /* # */
        .categories-table thead th:nth-child(2) { width: 15% !important; } /* Naam */
        .categories-table thead th:nth-child(3) { width: 15% !important; } /* Slug */
        .categories-table thead th:nth-child(4) { width: 25% !important; } /* Beschrijving */
        .categories-table thead th:nth-child(5) { width: 80px !important; } /* Producten */
        .categories-table thead th:nth-child(6) { width: 80px !important; } /* Volgorde */
        .categories-table thead th:nth-child(7) { width: 100px !important; } /* Status */
        .categories-table thead th:nth-child(8) { width: 120px !important; } /* Acties */
        
        .categories-table tbody td {
            padding: 0.875rem 1rem !important;
            font-size: 0.875rem !important;
            color: #0f172a !important;
            border-bottom: 1px solid #f1f5f9 !important;
            vertical-align: middle !important;
            /* Prevent text overflow */
            overflow: hidden !important;
            text-overflow: ellipsis !important;
        }
        
        .categories-table tbody tr:hover {
            background: #f8fafc !important;
        }
        
        .categories-table code {
            font-size: 0.8125rem !important;
            background: #f8fafc !important;
            padding: 0.25rem 0.5rem !important;
            border-radius: 4px !important;
            color: #0f172a !important;
            font-family: 'Courier New', monospace !important;
        }
        
        .table-actions {
            white-space: nowrap !important;
        }
        
        .page-actions-bar {
            display: flex !important;
            justify-content: space-between !important;
            align-items: center !important;
            gap: 1.5rem !important;
            padding: 1.5rem 0 !important;
            margin-bottom: 2rem !important;
            border-bottom: 1px solid #e2e8f0 !important;
        }
    </style>
    <?php elseif (strpos($currentPath, '/dashboard/products') !== false): ?>
    <style>
        /* Critical Products Table CSS - Prevents layout shift during page load */
        .products-section {
            background: white !important;
            border: 1px solid #e2e8f0 !important;
            border-radius: 8px !important;
            overflow: hidden !important;
            /* Prevent layout shift */
            contain: layout style !important;
        }
        
        .products-header {
            padding: 1rem 1.5rem !important;
            border-bottom: 1px solid #e2e8f0 !important;
            background: #f8fafc !important;
        }
        
        .products-header h3 {
            font-size: 1rem !important;
            font-weight: 600 !important;
            color: #0f172a !important;
            margin: 0 !important;
        }
        
        .table-responsive {
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch !important;
        }
        
        .products-table {
            width: 100% !important;
            border-collapse: separate !important;
            border-spacing: 0 !important;
            /* Fixed table layout prevents column collapse */
            table-layout: fixed !important;
        }
        
        .products-table thead th {
            padding: 0.75rem 1rem !important;
            text-align: left !important;
            font-size: 0.75rem !important;
            font-weight: 700 !important;
            text-transform: uppercase !important;
            letter-spacing: 0.05em !important;
            color: #64748b !important;
            border-bottom: 2px solid #e2e8f0 !important;
            background: transparent !important;
            /* Fixed column widths to prevent collapse */
            white-space: nowrap !important;
        }
        
        /* Fixed column widths - prevents "ingeklapte" columns */
        .products-table thead th:nth-child(1) { width: 80px !important; } /* Afbeelding */
        .products-table thead th:nth-child(2) { width: 100px !important; } /* Product ID */
        .products-table thead th:nth-child(3) { width: 20% !important; } /* Naam */
        .products-table thead th:nth-child(4) { width: 12% !important; } /* Categorie */
        .products-table thead th:nth-child(5) { width: 12% !important; } /* SKU */
        .products-table thead th:nth-child(6) { width: 15% !important; } /* Prijs */
        .products-table thead th:nth-child(7) { width: 100px !important; } /* Status */
        .products-table thead th:nth-child(8) { width: 120px !important; } /* Acties */
        
        .products-table tbody td {
            padding: 0.875rem 1rem !important;
            font-size: 0.875rem !important;
            color: #0f172a !important;
            border-bottom: 1px solid #f1f5f9 !important;
            vertical-align: middle !important;
            /* Prevent text overflow */
            overflow: hidden !important;
            text-overflow: ellipsis !important;
        }
        
        .products-table tbody tr:hover {
            background: #f8fafc !important;
        }
        
        .products-table code {
            font-size: 0.8125rem !important;
            background: #f8fafc !important;
            padding: 0.25rem 0.5rem !important;
            border-radius: 4px !important;
            color: #0f172a !important;
            font-family: 'Courier New', monospace !important;
        }
        
        .table-actions {
            white-space: nowrap !important;
        }
        
        .page-actions-bar {
            display: flex !important;
            justify-content: space-between !important;
            align-items: center !important;
            gap: 1.5rem !important;
            padding: 1.5rem 0 !important;
            margin-bottom: 2rem !important;
            border-bottom: 1px solid #e2e8f0 !important;
        }
    </style>
    <?php endif; ?>
    
    <?php
    // Load page-specific CSS (non-critical, loads after critical inline CSS)
    if (strpos($currentPath, '/dashboard/products') !== false) {
        echo '<link rel="stylesheet" href="' . asset('css/products.css') . '">';
    } elseif (strpos($currentPath, '/dashboard/categories') !== false) {
        echo '<link rel="stylesheet" href="' . asset('css/categories.css') . '">';
    } elseif (strpos($currentPath, '/dashboard/orders') !== false) {
        echo '<link rel="stylesheet" href="' . asset('css/orders.css') . '">';
    }
    ?>
</head>
<body>
    <?php if (isset($user) && $user): ?>
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header" style="text-align: center; padding: 1.5rem;">
                <h2 style="color: white; font-size: 1.25rem; margin: 0;">Oraviare</h2>
                <p style="color: rgba(255,255,255,0.7); font-size: 0.875rem; margin: 0.5rem 0 0 0;">Admin Dashboard</p>
            </div>
            
            <nav class="sidebar-nav">
                <a href="<?= url('/dashboard') ?>" class="nav-item <?= strpos($_SERVER['REQUEST_URI'], '/dashboard') !== false && strpos($_SERVER['REQUEST_URI'], '/dashboard/orders') === false && strpos($_SERVER['REQUEST_URI'], '/dashboard/settings') === false ? 'active' : '' ?>">
                    <i class="fas fa-chart-line"></i>
                    <span>Dashboard</span>
                </a>
                
                <a href="<?= url('/dashboard/orders') ?>" class="nav-item <?= strpos($_SERVER['REQUEST_URI'], '/dashboard/orders') !== false ? 'active' : '' ?>">
                    <i class="fas fa-shopping-cart"></i>
                    <span>Orders</span>
                </a>
                
                <a href="<?= url('/dashboard/products') ?>" class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/dashboard/products') !== false) ? 'active' : '' ?>">
                    <i class="fas fa-box"></i>
                    <span>Producten</span>
                </a>
                
                <a href="<?= url('/dashboard/categories') ?>" class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/dashboard/categories') !== false) ? 'active' : '' ?>">
                    <i class="fas fa-folder"></i>
                    <span>Categorieën</span>
                </a>
                
                <a href="<?= url('/dashboard/settings') ?>" class="nav-item <?= strpos($_SERVER['REQUEST_URI'], '/dashboard/settings') !== false ? 'active' : '' ?>">
                    <i class="fas fa-cog"></i>
                    <span>Instellingen</span>
                </a>
                
                <a href="<?= url('/logout') ?>" class="nav-item logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Uitloggen</span>
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <div class="main-content">
            <!-- Top Bar -->
            <header class="topbar">
                <div class="topbar-left">
                    <h1><?= $title ?? 'Dashboard' ?></h1>
                </div>
                <div class="topbar-right">
                    <div class="user-info">
                        <i class="fas fa-user-circle"></i>
                        <span><?= e($user['username'] ?? 'Gebruiker') ?></span>
                    </div>
                </div>
            </header>

            <!-- Flash Messages -->
            <?php if ($success = flash('success')): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?= e($success) ?>
                </div>
            <?php endif; ?>

            <?php if ($error = flash('error')): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= e($error) ?>
                </div>
            <?php endif; ?>

            <!-- Page Content -->
            <div class="content-wrapper">
                <?php require __DIR__ . '/../' . $contentView; ?>
            </div>
        </div>
    <?php else: ?>
        <!-- Guest Layout (voor login) -->
        <?php require __DIR__ . '/../' . $contentView; ?>
    <?php endif; ?>

    <script src="<?= asset('js/main.js') ?>"></script>
</body>
</html>

