<div class="page-header" style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 2rem; padding-bottom: 1rem; border-bottom: 1px solid #e2e8f0;">
    <div style="display: flex; align-items: center; gap: 1rem;">
        <a href="<?= url('/dashboard/products') ?>" style="color: #64748b; text-decoration: none; font-size: 0.875rem; font-weight: 500; transition: color 0.2s;" onmouseover="this.style.color='#0f172a';" onmouseout="this.style.color='#64748b';">
            <i class="fas fa-arrow-left"></i> Terug
        </a>
        <span style="color: #cbd5e1;">|</span>
        <h1 style="font-size: 1.5rem; font-weight: 600; color: #0f172a; margin: 0;">Nieuw Product</h1>
    </div>
</div>

<div class="form-container">
    <form method="POST" action="<?= url('/dashboard/products/create') ?>" class="product-form" enctype="multipart/form-data">
        <?= csrf_field() ?>

        <div class="card">
            <div class="card-header">
                <h3>Product Informatie</h3>
            </div>
            <div class="card-body">
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="product_id">Product ID *</label>
                        <input 
                            type="text" 
                            id="product_id" 
                            name="product_id" 
                            class="form-control"
                            placeholder="STOEL-WHITE-BEIGE"
                            required
                            pattern="[A-Z0-9\-_]+"
                            title="Alleen hoofdletters, cijfers, streepjes en underscores"
                        >
                        <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                            Unieke identifier (bijv. STOEL-001, LAMP-DESIGN)
                        </small>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="name">Productnaam *</label>
                        <input 
                            type="text" 
                            id="name" 
                            name="name" 
                            class="form-control"
                            placeholder="Witte Design Stoel met Beige Accenten"
                            required
                        >
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="sku">SKU</label>
                        <input 
                            type="text" 
                            id="sku" 
                            name="sku" 
                            class="form-control"
                            placeholder="STOEL-WHITE-BEIGE"
                        >
                        <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                            Optioneel: Stock Keeping Unit
                        </small>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="category">Categorie</label>
                        <select 
                            id="category" 
                            name="category" 
                            class="form-control"
                        >
                            <option value="">Geen categorie</option>
                            <option value="Stoelen">Stoelen</option>
                            <option value="Tafels">Tafels</option>
                            <option value="Lampen">Lampen</option>
                            <option value="Kussens">Kussens</option>
                            <option value="Vazen">Vazen</option>
                            <option value="Decoratie">Decoratie</option>
                            <option value="Accessoires">Accessoires</option>
                        </select>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="price">Prijs *</label>
                        <input 
                            type="number" 
                            id="price" 
                            name="price" 
                            class="form-control"
                            step="0.01"
                            min="0"
                            placeholder="9.99"
                            required
                        >
                    </div>

                    <div class="form-group col-md-4">
                        <label for="compare_price">Vergelijkingsprijs</label>
                        <input 
                            type="number" 
                            id="compare_price" 
                            name="compare_price" 
                            class="form-control"
                            step="0.01"
                            min="0"
                            placeholder="19.99"
                        >
                        <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                            Originele prijs (voor korting weergave)
                        </small>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="currency">Currency</label>
                        <select 
                            id="currency" 
                            name="currency" 
                            class="form-control"
                        >
                            <option value="EUR" selected>EUR</option>
                            <option value="USD">USD</option>
                            <option value="GBP">GBP</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="description">Beschrijving</label>
                    <div id="description-editor" style="min-height: 200px; border: 1px solid #e2e8f0; border-radius: 6px; background: #fff;"></div>
                    <textarea 
                        id="description" 
                        name="description" 
                        style="display: none;"
                    ></textarea>
                </div>

                <div class="form-group">
                    <label for="images" class="form-label">Afbeeldingen</label>
                    
                    <input 
                        type="file" 
                        id="images" 
                        name="images[]" 
                        class="form-control file-input"
                        accept="image/*"
                        multiple
                        onchange="previewImages(this)"
                    >
                    
                    <div class="existing-images" style="margin-top: 1.5rem;">
                        <div class="images-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 1rem;"></div>
                    </div>
                </div>

                <div class="form-group">
                    <div class="toggle-container">
                        <span class="toggle-label">Product is actief</span>
                        <label class="toggle-switch">
                            <input 
                                type="checkbox" 
                                name="is_active" 
                                value="1" 
                                checked
                                class="toggle-input"
                            >
                            <span class="toggle-slider"></span>
                        </label>
                    </div>
                    <small class="form-hint" style="margin-left: 0;">
                        Alleen actieve producten zijn zichtbaar voor VPS1
                    </small>
                </div>
            </div>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 2rem;">
            <button type="submit" class="btn btn-primary" style="flex: 0 0 auto;">
                <i class="fas fa-save"></i> Product Opslaan
            </button>
            <a href="<?= url('/dashboard/products') ?>" class="btn btn-secondary" style="flex: 0 0 auto;">
                Annuleren
            </a>
        </div>
    </form>
</div>

<style>
.form-container {
    width: 100%;
    max-width: 100%;
}

.product-form {
    width: 100%;
}

.product-form .card {
    width: 100%;
}

.form-row {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.form-group {
    flex: 1;
    margin-bottom: 0;
}

.form-group label,
.form-label {
    display: block;
    font-weight: 500;
    color: #0f172a;
    margin-bottom: 0.75rem;
    font-size: 0.875rem;
}

.form-control {
    width: 100%;
    padding: 0.625rem 0.875rem;
    font-size: 0.9375rem;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    outline: none;
    border-color: #0f172a;
    box-shadow: 0 0 0 3px rgba(15, 23, 42, 0.05);
}

/* File input styling */
.file-input {
    padding: 0.5rem;
    cursor: pointer;
    margin-bottom: 1.5rem;
}

.file-input::-webkit-file-upload-button {
    padding: 0.5rem 1rem;
    background: #0f172a;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-weight: 500;
    transition: background 0.2s;
}

.file-input::-webkit-file-upload-button:hover {
    background: #1e293b;
}

/* iOS-style Toggle Switch */
.toggle-container {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0.75rem 0;
}

.toggle-label {
    font-weight: 500;
    color: #0f172a;
    font-size: 0.9375rem;
}

.toggle-switch {
    position: relative;
    display: inline-block;
    width: 51px;
    height: 31px;
    flex-shrink: 0;
}

.toggle-input {
    opacity: 0;
    width: 0;
    height: 0;
}

.toggle-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #e2e8f0;
    transition: 0.3s;
    border-radius: 31px;
}

.toggle-slider:before {
    position: absolute;
    content: "";
    height: 27px;
    width: 27px;
    left: 2px;
    bottom: 2px;
    background-color: white;
    transition: 0.3s;
    border-radius: 50%;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.toggle-input:checked + .toggle-slider {
    background-color: #34c759;
}

.toggle-input:focus + .toggle-slider {
    box-shadow: 0 0 0 3px rgba(52, 199, 89, 0.2);
}

.toggle-input:checked + .toggle-slider:before {
    transform: translateX(20px);
}

.form-hint {
    display: block;
    color: #64748b;
    font-size: 0.75rem;
    margin-top: 0.5rem;
}

textarea.form-control {
    resize: vertical;
    min-height: 100px;
}

.card {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    overflow: hidden;
}

.card-header {
    padding: 1rem 1.5rem;
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
}

.card-header h3 {
    font-size: 1rem;
    font-weight: 600;
    color: #0f172a;
    margin: 0;
}

.card-body {
    padding: 1.5rem;
}

.primary-indicator-btn:hover {
    background: #0f172a !important;
    color: white !important;
    border-color: #0f172a !important;
}
.primary-indicator-btn:hover i {
    display: block !important;
}
</style>

<script>
let newImageCounter = 0;

function previewImages(input) {
    const imagesGrid = document.querySelector('.images-grid');
    if (!imagesGrid) return;
    
    if (input.files && input.files.length > 0) {
        Array.from(input.files).forEach((file, index) => {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                newImageCounter++;
                const tempId = 'new-image-' + newImageCounter;
                
                const containerDiv = document.createElement('div');
                containerDiv.setAttribute('data-temp-id', tempId);
                containerDiv.setAttribute('data-is-new', 'true');
                containerDiv.style.cssText = 'position: relative; border: 2px solid #e2e8f0; border-radius: 6px; padding: 6px; background: #fff; transition: all 0.3s;';
                containerDiv._fileObject = file;
                
                const imageWrapper = document.createElement('div');
                imageWrapper.className = 'image-wrapper';
                imageWrapper.style.cssText = 'position: relative; width: 100%; height: 140px; border-radius: 4px; overflow: hidden; border: 1px solid #e2e8f0;';
                
                const img = document.createElement('img');
                img.src = e.target.result;
                img.style.cssText = 'width: 100%; height: 100%; object-fit: cover; display: block;';
                img.alt = 'Nieuwe afbeelding ' + newImageCounter;
                
                const primaryIndicator = document.createElement('div');
                primaryIndicator.className = 'primary-indicator-wrapper';
                primaryIndicator.style.cssText = 'position: absolute; top: 8px; left: 8px; z-index: 10;';
                if (index === 0) {
                    containerDiv.style.border = '2px solid #0f172a';
                    containerDiv.style.background = '#f8fafc';
                    primaryIndicator.innerHTML = '<div class="primary-indicator-active" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;"><i class="fas fa-check" style="font-size: 0.875rem;"></i></div>';
                } else {
                    primaryIndicator.innerHTML = '<button type="button" class="primary-indicator-btn" data-temp-id="' + tempId + '" style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent;" title="Maak hoofdfoto"><i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i></button>';
                }
                
                const deleteBtnWrapper = document.createElement('div');
                deleteBtnWrapper.style.cssText = 'position: absolute; top: 8px; right: 8px; z-index: 10;';
                
                const deleteBtn = document.createElement('button');
                deleteBtn.type = 'button';
                deleteBtn.style.cssText = 'width: 36px; height: 36px; border-radius: 50%; background: rgba(220, 38, 38, 0.95); border: 1px solid #dc2626; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: white;';
                deleteBtn.title = 'Verwijderen';
                deleteBtn.innerHTML = '<i class="fas fa-trash" style="font-size: 0.75rem;"></i>';
                deleteBtn.onclick = function() {
                    if (confirm('Weet je zeker dat je deze afbeelding wilt verwijderen?')) {
                        containerDiv.style.transition = 'all 0.3s ease';
                        containerDiv.style.transform = 'scale(0)';
                        containerDiv.style.opacity = '0';
                        setTimeout(() => {
                            containerDiv.remove();
                            removeFileFromInput(input, file);
                            updatePrimaryIndicators();
                        }, 300);
                    }
                };
                
                deleteBtnWrapper.appendChild(deleteBtn);
                imageWrapper.appendChild(img);
                imageWrapper.appendChild(primaryIndicator);
                imageWrapper.appendChild(deleteBtnWrapper);
                containerDiv.appendChild(imageWrapper);
                imagesGrid.appendChild(containerDiv);
            };
            
            reader.readAsDataURL(file);
        });
    }
}

function removeFileFromInput(input, fileToRemove) {
    const dt = new DataTransfer();
    const files = Array.from(input.files);
    files.forEach(file => {
        if (file !== fileToRemove) {
            dt.items.add(file);
        }
    });
    input.files = dt.files;
}

function setPrimaryImage(tempId, input) {
    const imagesGrid = document.querySelector('.images-grid');
    if (!imagesGrid) return;
    
    const allImages = imagesGrid.querySelectorAll('[data-temp-id]');
    const targetImage = imagesGrid.querySelector(`[data-temp-id="${tempId}"]`);
    if (!targetImage || !targetImage._fileObject) return;
    
    const selectedFile = targetImage._fileObject;
    const newFiles = [selectedFile];
    allImages.forEach(img => {
        if (img !== targetImage && img._fileObject) {
            newFiles.push(img._fileObject);
        }
    });
    
    const dt = new DataTransfer();
    newFiles.forEach(file => dt.items.add(file));
    input.files = dt.files;
    
    imagesGrid.insertBefore(targetImage, imagesGrid.firstChild);
    const updatedImages = imagesGrid.querySelectorAll('[data-temp-id]');
    
    updatedImages.forEach((img, index) => {
        const indicatorWrapper = img.querySelector('.primary-indicator-wrapper');
        if (!indicatorWrapper) return;
        
        if (index === 0) {
            img.style.border = '2px solid #0f172a';
            img.style.background = '#f8fafc';
            const btn = indicatorWrapper.querySelector('.primary-indicator-btn');
            if (btn) {
                indicatorWrapper.innerHTML = '<div class="primary-indicator-active" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;"><i class="fas fa-check" style="font-size: 0.875rem;"></i></div>';
            }
        } else {
            img.style.border = '2px solid #e2e8f0';
            img.style.background = '#fff';
            const activeDiv = indicatorWrapper.querySelector('.primary-indicator-active');
            if (activeDiv) {
                const tempIdAttr = img.getAttribute('data-temp-id');
                indicatorWrapper.innerHTML = '<button type="button" class="primary-indicator-btn" data-temp-id="' + tempIdAttr + '" style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent;" title="Maak hoofdfoto"><i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i></button>';
            }
        }
    });
}

function updatePrimaryIndicators() {
    const imagesGrid = document.querySelector('.images-grid');
    if (!imagesGrid) return;
    
    const images = imagesGrid.querySelectorAll('[data-temp-id]');
    if (images.length > 0) {
        images.forEach((img, index) => {
            const indicatorWrapper = img.querySelector('.primary-indicator-wrapper');
            if (!indicatorWrapper) return;
            
            if (index === 0) {
                img.style.border = '2px solid #0f172a';
                img.style.background = '#f8fafc';
                const btn = indicatorWrapper.querySelector('.primary-indicator-btn');
                if (btn) {
                    const tempIdAttr = btn.getAttribute('data-temp-id');
                    indicatorWrapper.innerHTML = '<div class="primary-indicator-active" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;"><i class="fas fa-check" style="font-size: 0.875rem;"></i></div>';
                }
            } else {
                img.style.border = '2px solid #e2e8f0';
                img.style.background = '#fff';
                const activeDiv = indicatorWrapper.querySelector('.primary-indicator-active');
                if (activeDiv) {
                    const tempIdAttr = img.getAttribute('data-temp-id');
                    indicatorWrapper.innerHTML = '<button type="button" class="primary-indicator-btn" data-temp-id="' + tempIdAttr + '" style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent;" title="Maak hoofdfoto"><i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i></button>';
                }
            }
        });
    }
}

document.addEventListener('click', function(e) {
    const btn = e.target.closest('.primary-indicator-btn');
    if (btn) {
        e.preventDefault();
        e.stopPropagation();
        const tempId = btn.getAttribute('data-temp-id');
        const input = document.getElementById('images');
        if (tempId && input) {
            setPrimaryImage(tempId, input);
        }
    }
}, true);

document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.product-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            if (window.quill) {
                const descriptionTextarea = document.getElementById('description');
                if (descriptionTextarea) {
                    descriptionTextarea.value = window.quill.root.innerHTML;
                }
            }
        });
    }
});
</script>

<!-- Quill Rich Text Editor -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const editorContainer = document.getElementById('description-editor');
    const descriptionTextarea = document.getElementById('description');
    
    if (editorContainer && descriptionTextarea) {
        window.quill = new Quill('#description-editor', {
            theme: 'snow',
            modules: {
                toolbar: [
                    [{ 'header': [1, 2, 3, false] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    ['link'],
                    [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                    [{ 'color': [] }, { 'background': [] }],
                    ['clean']
                ]
            },
            placeholder: 'Voeg een productbeschrijving toe...'
        });
        
        const initialContent = descriptionTextarea.value;
        if (initialContent) {
            window.quill.root.innerHTML = initialContent;
        }
        
        window.quill.on('text-change', function() {
            descriptionTextarea.value = window.quill.root.innerHTML;
        });
        
        const style = document.createElement('style');
        style.textContent = `
            .ql-container {
                font-family: 'Inter', sans-serif;
                font-size: 0.9375rem;
                border-bottom-left-radius: 6px;
                border-bottom-right-radius: 6px;
            }
            .ql-toolbar {
                border-top-left-radius: 6px;
                border-top-right-radius: 6px;
                border: 1px solid #e2e8f0;
                border-bottom: none;
                background: #f8fafc;
            }
            .ql-container {
                border: 1px solid #e2e8f0;
                border-top: none;
            }
            .ql-editor {
                min-height: 200px;
                padding: 1rem;
            }
            .ql-editor.ql-blank::before {
                color: #94a3b8;
                font-style: normal;
            }
            .ql-snow .ql-stroke {
                stroke: #64748b;
            }
            .ql-snow .ql-fill {
                fill: #64748b;
            }
            .ql-snow .ql-picker-label:hover .ql-stroke,
            .ql-snow .ql-picker-label.ql-active .ql-stroke {
                stroke: #0f172a;
            }
            .ql-snow .ql-picker-label:hover .ql-fill,
            .ql-snow .ql-picker-label.ql-active .ql-fill {
                fill: #0f172a;
            }
            .ql-snow button:hover,
            .ql-snow button.ql-active {
                color: #0f172a;
            }
        `;
        document.head.appendChild(style);
    }
});
</script>
