<!-- Page Actions Bar -->
<div class="page-actions-bar">
    <div class="page-description">
        <p>Beheer alle furniture producten</p>
    </div>
    <div class="page-actions">
        <a href="<?= url('/dashboard/products/create') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i>
            <span>Nieuw Product</span>
        </a>
    </div>
</div>

<div class="products-section">
    <div class="products-header">
        <h3>Alle Producten</h3>
    </div>
    <?php if (!empty($products)): ?>
        <div class="table-responsive">
            <table class="table products-table">
                <thead>
                    <tr>
                        <th>Afbeelding</th>
                        <th>Product ID</th>
                        <th>Naam</th>
                        <th>Categorie</th>
                        <th>SKU</th>
                        <th>Prijs</th>
                        <th>Status</th>
                        <th>Acties</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $product): ?>
                        <tr>
                            <td>
                                <?php 
                                $displayImage = $product['image_url'] ?? null;
                                if (!empty($displayImage)): 
                                ?>
                                    <img src="<?= url('/' . $displayImage) ?>" 
                                         alt="<?= e($product['name']) ?>" 
                                         style="width: 50px; height: 50px; object-fit: cover; border-radius: 6px; border: 1px solid #e2e8f0;">
                                <?php else: ?>
                                    <div style="width: 50px; height: 50px; background: #f1f5f9; border-radius: 6px; display: flex; align-items: center; justify-content: center; color: #94a3b8; border: 1px solid #e2e8f0;">
                                        <i class="fas fa-image" style="font-size: 1rem;"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td><code><?= e($product['product_id']) ?></code></td>
                            <td><strong><?= e($product['name']) ?></strong></td>
                            <td>
                                <?php if (!empty($product['category'])): ?>
                                    <span class="badge badge-light"><?= e($product['category']) ?></span>
                                <?php else: ?>
                                    <span style="color: #94a3b8;">-</span>
                                <?php endif; ?>
                            </td>
                            <td><?= e($product['sku'] ?? '-') ?></td>
                            <td>
                                <div style="display: flex; flex-direction: column; gap: 0.25rem;">
                                    <?php 
                                    $price = (float)($product['price'] ?? 0);
                                    $comparePrice = !empty($product['compare_price']) ? (float)$product['compare_price'] : null;
                                    
                                    if ($comparePrice !== null && $comparePrice > $price): ?>
                                        <div>
                                            <span style="text-decoration: line-through; color: #64748b; font-size: 0.8125rem;">
                                                <?= format_price($comparePrice) ?>
                                            </span>
                                        </div>
                                        <div>
                                            <strong style="color: #0f172a;"><?= format_price($price) ?></strong>
                                            <?php 
                                            $discount = round((($comparePrice - $price) / $comparePrice) * 100);
                                            if ($discount > 0):
                                            ?>
                                                <span class="badge badge-danger" style="margin-left: 0.5rem; font-size: 0.6875rem;">
                                                    -<?= $discount ?>%
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    <?php else: ?>
                                        <div>
                                            <strong style="color: #0f172a;"><?= format_price($price) ?></strong>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-<?= $product['is_active'] ? 'success' : 'secondary' ?>">
                                    <?= $product['is_active'] ? 'Actief' : 'Inactief' ?>
                                </span>
                            </td>
                            <td class="table-actions">
                                <div style="display: inline-flex; align-items: center; gap: 0.375rem;">
                                    <a href="<?= url('/dashboard/products/edit/' . $product['id']) ?>" 
                                       class="btn btn-sm btn-primary" 
                                       title="Bewerken">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form method="POST" 
                                          action="<?= url('/dashboard/products/delete/' . $product['id']) ?>" 
                                          style="display: inline-flex; align-items: center; margin: 0;" 
                                          onsubmit="return confirm('Weet je zeker dat je dit product wilt verwijderen?');">
                                        <?= csrf_field() ?>
                                        <button type="submit" class="btn btn-sm btn-danger" title="Verwijderen">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="products-empty">
            <i class="fas fa-box-open"></i>
            <div class="products-empty-content">
                <p class="products-empty-title">Geen producten gevonden</p>
                <p class="products-empty-text">Voeg je eerste furniture product toe om te beginnen.</p>
                <a href="<?= url('/dashboard/products/create') ?>" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> Nieuw Product
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>
