<?php
/**
 * VPS2 Furniture Shop - Front Controller
 * 
 * Dit is het centrale toegangspunt voor alle requests.
 * API endpoints voor VPS1 order processing en payment handling.
 */

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Session configuratie
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
session_start();

// Autoloader voor Core en App classes
spl_autoload_register(function ($class) {
    $base_dir = __DIR__ . '/../';
    
    // Vervang namespace separators met directory separators
    $file = $base_dir . str_replace('\\', '/', $class) . '.php';
    
    // Als het bestand bestaat, require het
    if (file_exists($file)) {
        require_once $file;
        return true;
    }
    
    // Probeer ook zonder namespace (voor backward compatibility)
    $class_name = basename(str_replace('\\', '/', $class));
    $file = $base_dir . $class_name . '.php';
    if (file_exists($file)) {
        require_once $file;
        return true;
    }
    
    return false;
});

// Configuratie laden
$appConfig = require __DIR__ . '/../config/app.php';

// Timezone instellen
date_default_timezone_set($appConfig['timezone']);

// Helper functions laden
require_once __DIR__ . '/../core/helpers.php';

// Core classes direct requiren (voor betrouwbaarheid)
require_once __DIR__ . '/../core/Model.php';
require_once __DIR__ . '/../core/Controller.php';
require_once __DIR__ . '/../core/Router.php';
require_once __DIR__ . '/../core/Request.php';
require_once __DIR__ . '/../core/Database.php';

// App Models requiren
require_once __DIR__ . '/../app/Models/User.php';
require_once __DIR__ . '/../app/Models/FurnitureProduct.php';
require_once __DIR__ . '/../app/Models/FurnitureCategory.php';
require_once __DIR__ . '/../app/Models/FurnitureOrder.php';
require_once __DIR__ . '/../app/Models/FurnitureProductImage.php';
require_once __DIR__ . '/../app/Models/ApiCredential.php';

// App Controllers direct requiren (voor betrouwbaarheid)
require_once __DIR__ . '/../app/Controllers/AuthController.php';
require_once __DIR__ . '/../app/Controllers/DashboardController.php';
require_once __DIR__ . '/../app/Controllers/ProductController.php';
require_once __DIR__ . '/../app/Controllers/CategoryController.php';
require_once __DIR__ . '/../app/Controllers/OrderController.php';
require_once __DIR__ . '/../app/Controllers/OrderApiController.php';
require_once __DIR__ . '/../app/Controllers/ProductApiController.php';
require_once __DIR__ . '/../app/Controllers/CheckoutController.php';

// Router en Request initialiseren
use Core\Router;
use Core\Request;

$router = new Router();

// Routes laden
require_once __DIR__ . '/../routes/web.php';

// Request verwerken
$request = new Request();
$router->dispatch($request);

